/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api;

import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import noobanidus.mods.lootr.common.api.IMarkChanged;
import noobanidus.mods.lootr.common.api.annotation.ServerOnly;
import org.jetbrains.annotations.Nullable;

public interface IOpeners
extends IMarkChanged {
    @ServerOnly
    @Nullable
    public Set<UUID> getVisualOpeners();

    @Nullable
    public Set<UUID> getActualOpeners();

    default public boolean addOpener(class_1657 player) {
        boolean result1 = this.addVisualOpener(player);
        boolean result2 = this.addActualOpener(player);
        return result1 || result2;
    }

    default public boolean clearOpeners() {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        if (!openers.isEmpty()) {
            openers.clear();
            this.markChanged();
            return true;
        }
        return false;
    }

    default public boolean addVisualOpener(UUID uuid) {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        if (openers.add(uuid)) {
            this.markChanged();
            return true;
        }
        return false;
    }

    default public boolean hasVisualOpened(UUID uuid) {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        return !openers.isEmpty() && openers.contains(uuid);
    }

    default public boolean removeVisualOpener(UUID uuid) {
        Set<UUID> openers = this.getVisualOpeners();
        if (openers == null) {
            return false;
        }
        if (openers.remove(uuid)) {
            this.markChanged();
            return true;
        }
        return false;
    }

    default public boolean addActualOpener(UUID uuid) {
        Set<UUID> openers = this.getActualOpeners();
        if (openers == null) {
            return false;
        }
        if (openers.add(uuid)) {
            this.markChanged();
            return true;
        }
        return false;
    }

    @Deprecated
    default public boolean hasOpened(UUID uuid) {
        return this.hasServerOpened(uuid);
    }

    default public boolean hasServerOpened(UUID uuid) {
        Set<UUID> openers = this.getActualOpeners();
        if (openers == null) {
            return false;
        }
        return !openers.isEmpty() && openers.contains(uuid);
    }

    @Deprecated
    default public boolean hasOpened(class_1657 player) {
        return this.hasServerOpened(player.method_5667());
    }

    default public boolean hasServerOpened(class_1657 player) {
        return this.hasServerOpened(player.method_5667());
    }

    default public boolean addActualOpener(class_1657 player) {
        return this.addActualOpener(player.method_5667());
    }

    default public boolean addVisualOpener(class_1657 player) {
        return this.addVisualOpener(player.method_5667());
    }

    default public boolean hasVisualOpened(class_1657 player) {
        return this.hasVisualOpened(player.method_5667());
    }

    default public boolean removeVisualOpener(class_1657 player) {
        return this.removeVisualOpener(player.method_5667());
    }
}

